/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.blocks;

import dev.compactmods.crafting.api.components.IRecipeComponents;
import dev.compactmods.crafting.api.recipe.layers.IRecipeBlocks;
import dev.compactmods.crafting.recipes.blocks.ComponentPositionLookup;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RecipeBlocks
implements IRecipeBlocks {
    private AABB sourceBounds;
    private AABB filledBounds;
    private final ComponentPositionLookup lookup;
    private final Map<BlockPos, BlockState> states;
    private final Set<BlockPos> unmatchedStates;

    protected RecipeBlocks(AABB bounds) {
        this.sourceBounds = bounds;
        this.filledBounds = BlockSpaceUtil.getBoundsForBlocks(BlockSpaceUtil.getBlocksIn(bounds));
        this.lookup = new ComponentPositionLookup();
        this.states = new HashMap<BlockPos, BlockState>();
        this.unmatchedStates = new HashSet<BlockPos>();
    }

    public RecipeBlocks(IRecipeBlocks original) {
        this(original.getSourceBounds());
        this.copyInfoFrom(original, BlockPos.f_121853_);
    }

    public static RecipeBlocks createEmpty() {
        return new RecipeBlocks(AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.0, (double)0.0, (double)0.0));
    }

    private void copyInfoFrom(IRecipeBlocks original, BlockPos offset) {
        BlockSpaceUtil.getBlocksIn(this.sourceBounds).forEach(newPos -> {
            Optional<String> key = original.getComponentAtPosition((BlockPos)newPos);
            if (key.isPresent()) {
                this.lookup.add(newPos.m_141952_((Vec3i)offset).m_7949_(), key.get());
            } else {
                BlockState unidentified = original.getStateAtPosition((BlockPos)newPos);
                if (!unidentified.m_60795_()) {
                    this.unmatchedStates.add(newPos.m_141952_((Vec3i)offset).m_7949_());
                }
            }
            BlockState oState = original.getStateAtPosition((BlockPos)newPos);
            this.states.put(newPos.m_141952_((Vec3i)offset).m_7949_(), oState);
        });
        this.rebuildComponentTotals();
    }

    public RecipeBlocks(AABB bounds, Map<BlockPos, BlockState> states, Map<BlockPos, String> components, Set<BlockPos> unmatchedStates) {
        this(bounds);
        this.states.putAll(states);
        this.lookup.components.putAll(components);
        this.unmatchedStates.addAll(unmatchedStates);
        this.lookup.rebuildComponentTotals();
    }

    public static RecipeBlocks create(BlockGetter blocks, IRecipeComponents components, AABB bounds) {
        RecipeBlocks instance = new RecipeBlocks(bounds);
        BlockSpaceUtil.getBlocksIn(bounds).map(BlockPos::m_7949_).forEach(pos -> {
            BlockState state = blocks.m_8055_(pos);
            instance.states.put((BlockPos)pos, state);
            Optional<String> compKey = components.getKey(state);
            if (compKey.isPresent()) {
                instance.lookup.add((BlockPos)pos, compKey.get());
            } else {
                instance.unmatchedStates.add((BlockPos)pos);
            }
        });
        return instance;
    }

    @Override
    public AABB getSourceBounds() {
        return this.sourceBounds;
    }

    @Override
    public boolean allIdentified() {
        return this.unmatchedStates.isEmpty();
    }

    @Override
    public Stream<BlockPos> getUnmappedPositions() {
        return this.unmatchedStates.stream();
    }

    @Override
    public Stream<BlockPos> getPositionsForComponent(String component) {
        return this.lookup.getPositionsForComponent(component);
    }

    @Override
    public AABB getFilledBounds() {
        return this.filledBounds;
    }

    @Override
    public Optional<String> getComponentAtPosition(BlockPos relative) {
        return Optional.ofNullable(this.lookup.components.get(relative));
    }

    @Override
    public BlockState getStateAtPosition(BlockPos relative) {
        return this.states.get(relative);
    }

    @Override
    public Stream<BlockPos> getPositions() {
        return this.states.keySet().stream();
    }

    @Override
    public int getNumberKnownComponents() {
        return this.getKnownComponentTotals().keySet().size();
    }

    @Override
    public void rebuildComponentTotals() {
        this.lookup.rebuildComponentTotals();
    }

    @Override
    public Map<String, Integer> getKnownComponentTotals() {
        return this.lookup.componentTotals;
    }

    @Override
    public IRecipeBlocks slice(AABB bounds) {
        RecipeBlocks blocks = new RecipeBlocks(this.sourceBounds.m_82323_(bounds));
        blocks.copyInfoFrom(this, BlockPos.f_121853_);
        return blocks;
    }

    @Override
    public IRecipeBlocks offset(Vec3i amount) {
        RecipeBlocks copy = new RecipeBlocks(this.filledBounds);
        copy.copyInfoFrom(this, new BlockPos(amount));
        copy.filledBounds = copy.filledBounds.m_82383_(new Vec3((double)amount.m_123341_(), (double)amount.m_123342_(), (double)amount.m_123343_()));
        copy.sourceBounds = copy.sourceBounds.m_82338_(new BlockPos(amount));
        return copy;
    }
}

